/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.cfgtool;

import ibm.nways.cfgtool.CfgToolContext;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.StringInputRO;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;

public class CfgToolPanel
extends DestinationPropBook {
    private static ResourceBundle myResources = null;
    private CfgToolContext cfgtoolContext;
    protected Properties properties;
    protected static final String PropertiesFile = "properties/Cfg.txt";
    private static String title = "Configuration Tool";
    protected cfgtoolSection cfgtoolPropertySection;

    private static void loadStatics() {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.cfgtool.CfgToolPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel CfgTool");
        }
    }

    public String getDestinationTitle() {
        return CfgToolPanel.getTitle();
    }

    public static String getTitle() {
        CfgToolPanel.loadStatics();
        if (myResources != null) {
            title = CfgToolPanel.getNLSString("cfgtoolPanelTitle");
        }
        return title;
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public CfgToolPanel() {
        CfgToolPanel.loadStatics();
    }

    public void addSections() {
        NavigationContext navigationContext = this.getNavContext();
        this.cfgtoolContext = (CfgToolContext)navigationContext.get("cfgtoolContext");
        try {
            BrowserApplet browserApplet = this.getBrowser();
            URL uRL = new URL(browserApplet.getDocumentBase(), PropertiesFile);
            System.out.println("DocumentBase = " + browserApplet.getDocumentBase());
            this.properties = new Properties();
            this.properties.load(uRL.openStream());
        }
        catch (Exception exception) {
            System.out.println("Error getting CFG Properties: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.cfgtoolPropertySection = new cfgtoolSection(this.cfgtoolContext);
        this.addSection(CfgToolPanel.getNLSString("cfgtoolSectionTitle"), this.cfgtoolPropertySection);
        this.addApplyButton();
        this.addRefreshButton();
        this.addHelpButton();
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private class cfgtoolSection
    extends PropertySection {
        BrowserApplet browser;
        String cfgToolDirStr;
        String fullPathCfgToolNameStr;
        String fileSeparator = System.getProperty("file.separator");
        CfgToolContext cfgtoolContext;
        StringInputRO cfgtoolField = new StringInputRO();

        public cfgtoolSection(CfgToolContext cfgToolContext) {
            CfgToolPanel.this = CfgToolPanel.this;
            this.cfgtoolContext = cfgToolContext;
            this.setLayout(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
            this.browser = CfgToolPanel.this.getBrowser();
            this.addRow(CfgToolPanel.getNLSString("cfgtoolLabel"), (Component)this.cfgtoolField);
            String string = this.getProperty4DirName();
            System.out.println("cfgDirProperty = " + string);
            if (CfgToolPanel.this.properties != null) {
                String string2 = System.getProperty("os.name");
                this.cfgToolDirStr = (String)((Hashtable)CfgToolPanel.this.properties).get(string);
                String string3 = this.trimQuotes(this.cfgToolDirStr);
                String string4 = null;
                if (string2.equals("Windows NT")) {
                    string4 = (String)((Hashtable)CfgToolPanel.this.properties).get("CFG_TOOL_NAME");
                } else if (string2.equals("AIX")) {
                    string4 = (String)((Hashtable)CfgToolPanel.this.properties).get("AIX_CFG_TOOL_NAME");
                }
                string4 = this.trimQuotes(string4);
                this.fullPathCfgToolNameStr = String.valueOf(string3) + this.fileSeparator + string4;
            }
            System.out.println("Config tool directory = " + this.cfgToolDirStr);
            System.out.println("file separator = " + this.fileSeparator);
            System.out.println("Config tool = " + this.fullPathCfgToolNameStr);
            this.cfgtoolField.setText(this.fullPathCfgToolNameStr);
            this.reset();
        }

        private String trimQuotes(String string) {
            String string2 = string;
            if (string2 != null && string2.trim() != null) {
                int n;
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"") && (n = string2.lastIndexOf("\"")) != -1) {
                    string2 = string2.substring(0, n);
                }
            }
            return string2;
        }

        private String getProperty4DirName() {
            String string = System.getProperty("os.name");
            String string2 = null;
            System.out.println("os name s =" + string);
            if (string.equals("Windows NT")) {
                System.out.println("WindowsNT =" + string);
                string2 = new String("NT_" + this.cfgtoolContext.getVersion());
            } else if (string.equals("AIX")) {
                System.out.println("AIX" + string);
                string2 = new String("AIX_" + this.cfgtoolContext.getVersion());
            } else {
                System.out.println("Error" + string);
            }
            System.out.println("fullPathCfgToolName =" + string2);
            return string2;
        }

        public void apply() {
            String string = System.getProperty("os.name");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (this.browser.getIsApplication() && CfgToolPanel.this.properties != null) {
                string3 = (String)((Hashtable)CfgToolPanel.this.properties).get("CFG_TOOL_APP");
                string3 = this.trimQuotes(string3);
                this.cfgToolDirStr = this.trimQuotes(this.cfgToolDirStr);
                if (string.equals("Windows NT")) {
                    string5 = (String)((Hashtable)CfgToolPanel.this.properties).get("NT_CFG_SCRIPT");
                    string2 = (String)((Hashtable)CfgToolPanel.this.properties).get("CFG_TOOL_NAME");
                } else if (string.equals("AIX")) {
                    string5 = (String)((Hashtable)CfgToolPanel.this.properties).get("AIX_CFG_SCRIPT");
                    string2 = (String)((Hashtable)CfgToolPanel.this.properties).get("AIX_CFG_TOOL_NAME");
                }
                string2 = this.trimQuotes(string2);
                try {
                    String string6 = new String(string5);
                    System.out.println("cfgToolScriptFile=" + string6);
                    if (string.equals("Windows NT")) {
                        int n = this.cfgToolDirStr.indexOf(":");
                        if (n != -1) {
                            string4 = this.cfgToolDirStr.substring(n - 1, n + 1);
                        }
                        String[] stringArray = new String[]{string6, string4, this.cfgToolDirStr, string2, string3};
                        System.out.println("cfgToolScriptFile(cmdArray[0])=" + stringArray[0]);
                        System.out.println("drive(cmdArray[1])=" + stringArray[1]);
                        System.out.println("cfgToolDirStr(cmdArray[2])=" + stringArray[2]);
                        System.out.println("cfgExecutable(cmdArray[3])=" + stringArray[3]);
                        System.out.println("cfgEnvironment(cmdArray[4])=" + stringArray[4]);
                        CfgToolPanel.this.displayMsg(CfgToolPanel.getNLSString("launchingConfigurationTool"));
                        Runtime.getRuntime().exec(stringArray);
                        return;
                    }
                    if (string.equals("AIX")) {
                        string6 = this.trimQuotes(string6);
                        String[] stringArray = new String[]{string6, this.cfgToolDirStr, string2, string3};
                        System.out.println("cfgToolScriptFile(cmdArray[0])=" + stringArray[0]);
                        System.out.println("cfgToolDirStr(cmdArray[1])=" + stringArray[1]);
                        System.out.println("cfgExecutable(cmdArray[2])=" + stringArray[2]);
                        System.out.println("cfgEnvironment(cmdArray[3])=" + stringArray[3]);
                        CfgToolPanel.this.displayMsg(CfgToolPanel.getNLSString("launchingConfigurationTool"));
                        Runtime.getRuntime().exec(stringArray);
                        return;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    return;
                }
            }
        }

        public void reset() {
            this.doLayout();
        }
    }
}

